#ifndef cplayer_def

#define cplayer_def

class CPlayer
{
public:
    int score;
    bool has_hammer;
    int rocks_left, fake_rocks_left;
    BITMAP *flag;
    char *name;
    bool shooting;

    void init(BITMAP *_flag, char *_name, bool _hammer);
    void destroy(void);
    void not_shooting(void);
    int shoot(CStone *stone, Point *mouse_point);
    void toggle_hammer(void);
    void set_rocks(int n);
    void set_hammer(bool h);
};

void CPlayer::set_hammer(bool h)
{
    has_hammer = h;
}

void CPlayer::set_rocks(int n)
{
    rocks_left=n;
}

void CPlayer::toggle_hammer(void)
{
    if(has_hammer==true)
        has_hammer=false;
    else if(has_hammer==false)
        has_hammer=true;
}

int CPlayer::shoot(CStone *stone, Point *mouse_point)
{
    int ret=0;
    if(rocks_left>0)
        {
        rocks_left--;
        shooting=true;
        stone->shoot(mouse_point);
        ret=1;
        }
    return ret;
}

void CPlayer::not_shooting(void)
{
    //if(shooting==true)
    //    rocks_left--;
    shooting=false;
}

void CPlayer::destroy(void)
{
    destroy_bitmap(flag);
    delete(name);
}

void CPlayer::init(BITMAP *_flag, char *_name, bool _hammer)
{
    score=0;
    has_hammer=_hammer;
    rocks_left=8;
    fake_rocks_left=8;
    flag=_flag;
    name=_name;
    shooting=false;
}

#endif
